//Dustin Soodak




//Behavior 039: testing NavigationXY()
//imitating calculations on AccelXYGData tab of Moody1 spreadsheet
//there is "foating point version" and "int version"
//

//
#include "MiscHardware.h"
#include "Navigation.h"

char ch=0,mode=0;
String NumString=""; 
int leftmotor=100,rightmotor=100;


int dat[50][7];        //Holds up to 60 points of navigation data, five fields
int datpos=0;
int i;
int32_t lasttime;


//extern int CosDegr,SinDegr;
//extern int32_t accelxraw,accelyraw;
//extern int32_t accelx,accely;

void setup(){
  HardwareBegin();                                                                      //Initialize all pins & setup except navigation
  SwitchButtonToPixels();                                                               //Switches Button Pin to drive pixels
  PlayChirp(1000, 50);SetPixelRGB(5,50,0,50);SetPixelRGB(6,50,0,50);RefreshPixels();    
  delay(100);
  PlayChirp(1000, 0);SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();  
  SwitchPixelsToButton();
  SwitchMotorsToSerial();
  NavigationBegin();
  RestartTimer();            //Captures what MS timer was when this was called.  Use GetTime() to get MS since calling RestartTimer();  
}


void loop(){  
  //enter motor speeds
  SwitchPixelsToButton();    
  SwitchMotorsToSerial();
  Serial.println("Enter motors, press button to continue");
  Serial.print("motors: ");Serial.print(leftmotor,DEC);Serial.print(" ");Serial.println(rightmotor,DEC);
  Serial.println("enter left motor");
  mode=0;//in this case, used for motor selection
  while(!ButtonPressed()){
    if(Serial.available() > 0){
      ch = Serial.read();    
      if (isDigit(ch) || ch=='-'){        
        NumString += (char)ch;
      }
      if(ch=='\n'){
        if(mode==0){
          leftmotor=NumString.toInt();//-25 works well for robot 1
          Serial.print("motors: ");Serial.print(leftmotor,DEC);Serial.print(" ");Serial.println(rightmotor,DEC);
          Serial.println("enter right motor");
          mode=1;
        }  
        else if(mode==1){
          rightmotor=NumString.toInt();//-25 works well for robot 1
          Serial.print("motors: ");Serial.print(leftmotor,DEC);Serial.print(" ");Serial.println(rightmotor,DEC);
          Serial.println("enter left motor");
          mode=0;
        }
        NumString="";
      }
    }//end if(Serial.available() > 0)
  }//end while(!ButtonPressed())
  //move robot
  while(ButtonPressed());
  Serial.println("starting");
  SwitchButtonToPixels();
  SetPixelRGB(5,50,0,50);SetPixelRGB(6,50,0,50);RefreshPixels();
  delay(1000);
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();  

  //   <------ This is the important stuff
  NavigationBegin();                   //Initialize navigation completely, bot must be still when this is called otherwise it gets screwy
                                       //This captures the values presently output from the accel and gyro when sitting still and
                                       //uses these as a virtual "zero".
  SwitchSerialToMotors();
  Motors(leftmotor,rightmotor);        //Sets motor speed, acceptable values -255 to +255, has range checking in function
  datpos=0;                            //Index of where you are in the dat[][] array
  lasttime=0;                          //Used to time accquisition points timing based on GetTime() function
  mode=0;                              //Mode=0 if motors on,  Mode=1 if motors are off
  RestartTimer();                      //Zeros the reference to the internal Arduino milliscond timer
  while(GetTime()<1500){
    NavigationXY(50,800);               //Raw value out of accel and gyro range is -32,768 to +32,768
                                     //This must be called at least every 80 milliseconds or the gyro/accel data will overflow
                                     //and will no longer be accurate.  The parameter passed is the low threshold .  If raw
                                     //sensor reading is above this threshold (in any direction) position/veleocity values
                                     //will be updated.  If below this threshold, the position/velocity will not be updated.
                                       
    if(GetTime()>lasttime+33){
      lasttime=GetTime(); 
      dat[datpos][0]=GetPositionX();
      dat[datpos][1]=GetPositionY();
      dat[datpos][2]=GetDegrees();//GyroPosition[2]
      dat[datpos][3]=AccelAcceleration[0];//GetAccelerationX();
      dat[datpos][4]=AccelAcceleration[1];//GetAccelerationY();
      dat[datpos][5]=GyroVelocity[2];//GetDegreesPerSecond();
      dat[datpos][6]=GyroAccelerationZ;//GyroAccelerationZ*((float)2000*380)*0.0000355;
      datpos++;
    }
    if(GetTime()>1000 && mode==0){
      SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();  
      Motors(0,0);
      lasttime=0; 
      mode=1;
    }
  }    //end while(GetTime()<1500)
  PauseNavigation();
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
  SwitchMotorsToSerial();    
  //print out data
  SwitchPixelsToButton();
  while(!ButtonPressed());
  delay(10);
  while(ButtonPressed());//so button press doesn't interfere with pixels
  if(GyroFifoOverflow) Serial.print("g"); else Serial.print(" ");
  if(AccelFifoOverflow) Serial.print("a"); else Serial.print(" ");
  Serial.println();
   Serial.print(AccelZeroes[0]);Serial.print("\t");Serial.print(AccelZeroes[1]);Serial.print("\t");Serial.println(GyroZeroes[2]);
  Serial.println("x\ty\tdeg");
  for(i=0;i<datpos;i++){
    Serial.print(dat[i][0]);Serial.print("\t");Serial.print(dat[i][1]);Serial.print("\t");Serial.print(dat[i][2]);
    Serial.print("\t");Serial.print(dat[i][3]);Serial.print("\t");Serial.print(dat[i][4]);
    Serial.print("\t");Serial.print(dat[i][5]);Serial.print("\t");Serial.println(dat[i][6]);
  }
    
    
//  NavigationXY();
//  if(GetTime()>200){    
//    Serial.print("Dg ");Serial.print(GetDegrees());
//    Serial.print(" Xa ");Serial.print(GetAccelerationX());
//    Serial.print(" Ya ");Serial.print(GetAccelerationY());
//    Serial.print(" Za ");Serial.print(GetAccelerationZ());    
//    Serial.print(" X ");Serial.print(GetPositionX());
//    Serial.print(" Y ");Serial.print(GetPositionY());
//    //Serial.print(" X ");Serial.print(accelx);
//    //Serial.print(" Y ");Serial.print(accely);
//    if(GyroFifoOverflow) Serial.print("g"); else Serial.print(" ");
//    if(AccelFifoOverflow) Serial.print("a"); else Serial.print(" ");
//    Serial.println();
//    RestartTimer();
//  }
}





/*

//print received IR data
#include "MiscHardware.h"
void setup(){
  HardwareBegin(); 
  RxIRRestart();
}
int i;
void loop(){
  if(IsIRDone()){
      RxIRStop();
      for(i=0;i<IRNumOfBytes;i++){
        Serial.println(((unsigned char)IRBytes[i]),HEX);
      }
      RxIRRestart();
  }
}

*/


